<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'mautic/mautic';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'api-platform/core' => 'v4.1.19@1dcc0da1bc56f2161ecfa863f7820e332a622d37',
  'aws/aws-crt-php' => 'v1.2.4@eb0c6e4e142224a10b08f49ebf87f32611d162b2',
  'aws/aws-sdk-php' => '3.298.2@626f731c38e06ea483025334512f4c2afea1739d',
  'barryvdh/elfinder-flysystem-driver' => 'v0.4.3@064d5b2c89ca185f3736e7e5c906d76d3632b30c',
  'beberlei/doctrineextensions' => 'v1.3.0@008f162f191584a6c37c03a803f718802ba9dd9a',
  'bjeavons/zxcvbn-php' => '1.4.2@426f664501a0747beb8f3ee17ac30c7dd6327ffa',
  'brick/math' => '0.11.0@0ad82ce168c82ba30d1c01ec86116ab52f589478',
  'composer/ca-bundle' => '1.5.0@0c5ccfcfea312b5c5a190a21ac5cef93f74baf99',
  'composer/class-map-generator' => '1.3.3@61804f9973685ec7bead0fb7fe022825e3cd418e',
  'composer/composer' => '2.7.7@291942978f39435cf904d33739f98d7d4eca7b23',
  'composer/installers' => 'v2.3.0@12fb2dfe5e16183de69e784a7b84046c43d97e8e',
  'composer/metadata-minifier' => '1.0.0@c549d23829536f0d0e984aaabbf02af91f443207',
  'composer/package-versions-deprecated' => '1.11.99.1@7413f0b55a051e89485c5cb9f765fe24bb02a7b6',
  'composer/pcre' => '3.3.2@b2bed4734f0cc156ee1fe9c0da2550420d99a21e',
  'composer/semver' => '3.4.3@4313d26ada5e0c4edfbd1dc481a92ff7bff91f12',
  'composer/spdx-licenses' => '1.5.8@560bdcf8deb88ae5d611c80a2de8ea9d0358cc0a',
  'composer/xdebug-handler' => '3.0.5@6c1925561632e83d60a44492e0b344cf48ab85ef',
  'doctrine/annotations' => '2.0.2@901c2ee5d26eb64ff43c47976e114bf00843acf7',
  'doctrine/cache' => '2.2.0@1ca8f21980e770095a31456042471a57bc4c68fb',
  'doctrine/collections' => '2.4.0@9acfeea2e8666536edff3d77c531261c63680160',
  'doctrine/common' => '3.4.5@6c8fef961f67b8bc802ce3e32e3ebd1022907286',
  'doctrine/data-fixtures' => '1.8.2@6fb221da56dae2011b33d47508e3b8aeb1d91db5',
  'doctrine/dbal' => '3.7.3@ce594cbc39a4866c544f1a970d285ff0548221ad',
  'doctrine/deprecations' => '1.1.5@459c2f5dd3d6a4633d3b5f46ee2b1c40f57d3f38',
  'doctrine/doctrine-bundle' => '2.11.1@4089f1424b724786c062aea50aae5f773449b94b',
  'doctrine/doctrine-fixtures-bundle' => '3.5.1@c808a0c85c38c8ee265cc8405b456c1d2b38567d',
  'doctrine/doctrine-migrations-bundle' => '3.4.1@e858ce0f5c12b266dce7dce24834448355155da7',
  'doctrine/event-manager' => '2.0.1@b680156fa328f1dfd874fd48c7026c41570b9c6e',
  'doctrine/inflector' => '2.1.0@6d6c96277ea252fc1304627204c3d5e6e15faa3b',
  'doctrine/instantiator' => '2.0.0@c6222283fa3f4ac679f8b9ced9a4e23f163e80d0',
  'doctrine/lexer' => '3.0.1@31ad66abc0fc9e1a1f2d9bc6a42668d2fbbcd6dd',
  'doctrine/migrations' => '3.9.0@325b61e41d032f5f7d7e2d11cbefff656eadc9ab',
  'doctrine/orm' => '2.18.0@f2176a9ce56cafdfd1624d54bfdb076819083d5b',
  'doctrine/persistence' => '3.4.3@d59e6ef7caffe6a30f4b6f9e9079a75f52c64ae0',
  'doctrine/sql-formatter' => '1.1.3@25a06c7bf4c6b8218f47928654252863ffc890a5',
  'egulias/email-validator' => '4.0.4@d42c8731f0624ad6bdc8d3e5e9a4524f68801cfa',
  'exercise/htmlpurifier-bundle' => '5.1@a5399a26512e66bb8ccedc3278f34258ae05eabd',
  'ezyang/htmlpurifier' => 'v4.17.0@bbc513d79acf6691fa9cf10f192c90dd2957f18c',
  'friendsofsymfony/rest-bundle' => '3.8.0@d24736896518bae817bf0de8a6b682cb6535044b',
  'gaufrette/aws-s3-adapter' => 'v0.4.0@a37143f592d5cb0ba124451439af6e6da6784d89',
  'gaufrette/extras' => 'v0.1.0@a2af9a8c53591a4c43a38249e17bcdefdcea8a23',
  'geoip2/geoip2' => 'v2.13.0@6a41d8fbd6b90052bc34dff3b4252d0f88067b23',
  'giggsey/libphonenumber-for-php' => '8.13.29@b8fa0daf0c27bb6fdb5940e0288f203be7e5cfd4',
  'giggsey/locale' => '2.5@e6d4540109a01dd2bc7334cdc842d6a6a67cf239',
  'guzzlehttp/guzzle' => '7.9.3@7b2f29fe81dc4da0ca0ea7d42107a0845946ea77',
  'guzzlehttp/oauth-subscriber' => '0.8.1@92b619b03bd21396e51c62e6bce83467d2ce8f53',
  'guzzlehttp/promises' => '2.2.0@7c69f28996b0a6920945dd20b3857e499d9ca96c',
  'guzzlehttp/psr7' => '2.7.1@c2270caaabe631b3b44c85f99e5a04bbb8060d16',
  'helios-ag/fm-elfinder-bundle' => '12.7.3@8041092383efda82faee697dc1119840a4345eca',
  'illuminate/collections' => 'v10.48.28@48de3d6bc6aa779112ddcb608a3a96fc975d89d8',
  'illuminate/conditionable' => 'v10.48.28@3ee34ac306fafc2a6f19cd7cd68c9af389e432a5',
  'illuminate/contracts' => 'v10.48.28@f90663a69f926105a70b78060a31f3c64e2d1c74',
  'illuminate/macroable' => 'v10.48.28@dff667a46ac37b634dcf68909d9d41e94dc97c27',
  'intervention/image' => '2.7.2@04be355f8d6734c826045d02a1079ad658322dad',
  'ip2location/ip2location-php' => '7.2.5@5f637f2e95e51861b9d969aa98f4e5868074f922',
  'javer/lightsaml' => '1.9.0@b2b6129ac705539639debf94532484fdbaa4493a',
  'javer/sp-bundle' => '2.1.0@1c90c5ba9e64396c47dc1ea1c492b675f0469768',
  'javer/symfony-bridge' => '1.6.0@9d65dc277278b19ba29c7589ddb1f01d59603ed5',
  'jbroadway/urlify' => '1.2.4-stable@d0fafbaa1dc14e8039cdf5c72a932a8d1de1750e',
  'jms/metadata' => '2.8.0@7ca240dcac0c655eb15933ee55736ccd2ea0d7a6',
  'jms/serializer' => '3.32.5@7c88b1b02ff868eecc870eeddbb3b1250e4bd89c',
  'jms/serializer-bundle' => '5.5.1@0538a2bae32a448fdeded53d729308816b5ad2e8',
  'joomla/filter' => '3.0.5@06c9e672d15099622dbb56c8e2a7461ce26d37f6',
  'joomla/string' => '3.0.4@0b3d33564db389e27346f7e275c694897c939434',
  'justinrainbow/json-schema' => 'v5.2.13@fbbe7e5d79f618997bc3332a6f49246036c45793',
  'kamermans/guzzle-oauth2-subscriber' => 'v1.1.1@7c311987ce7dcb6bfcd8320cc64588ad8fca075a',
  'klapaudius/oauth-server-bundle' => '5.1.3@c67a39afd881b4a36adf6df74c2873b9a3ceb0b7',
  'klapaudius/oauth2-php' => '1.8.0@99b159388a002da2ca8f791b97eed4ff68e32d54',
  'knplabs/gaufrette' => 'v0.9.0@786247eba04d4693e88a80ca9fdabb634675dcac',
  'knplabs/knp-menu' => 'v3.4.0@bf7d89a7ef406fd2ec1aae6f30f722e844bf6d31',
  'knplabs/knp-menu-bundle' => 'v3.4.2@6a1e3e1f4131f9a5a967e36717a1fe680c183637',
  'league/flysystem' => '3.30.0@2203e3151755d874bb2943649dae1eb8533ac93e',
  'league/flysystem-local' => '3.30.0@6691915f77c7fb69adfb87dcd550052dc184ee10',
  'league/mime-type-detection' => '1.16.0@2d6702ff215bf922936ccc1ad31007edc76451b9',
  'maennchen/zipstream-php' => '2.4.0@3fa72e4c71a43f9e9118752a5c90e476a8dc9eb3',
  'markbaker/complex' => '3.0.2@95c56caa1cf5c766ad6d65b6344b807c1e8405b9',
  'markbaker/matrix' => '3.0.1@728434227fe21be27ff6d86621a1b13107a2562c',
  'matomo/device-detector' => '6.4.6@6f07f615199851548db47a900815d2ea2cdcde08',
  'matthiasmullie/minify' => '1.3.71@ae42a47d7fecc1fbb7277b2f2d84c37a33edc3b1',
  'matthiasmullie/path-converter' => '1.1.3@e7d13b2c7e2f2268e1424aaed02085518afa02d9',
  'mautic/core-lib' => '7.0.0-dev@e13608dc9a60dd642d8e6114c086ca8155657c26',
  'maxmind-db/reader' => 'v1.11.1@1e66f73ffcf25e17c7a910a1317e9720a95497c7',
  'maxmind/web-service-common' => 'v0.9.0@4dc5a3e8df38aea4ca3b1096cee3a038094e9b53',
  'monolog/monolog' => '3.9.0@10d85740180ecba7896c87e06a166e0c95a0e3b6',
  'mtdowling/jmespath.php' => '2.7.0@bbb69a935c2cbb0c03d7f481a238027430f6440b',
  'mustangostang/spyc' => '0.6.3@4627c838b16550b666d15aeae1e5289dd5b77da0',
  'myclabs/php-enum' => '1.8.4@a867478eae49c9f59ece437ae7f9506bfaa27483',
  'oneup/uploader-bundle' => '5.0.1@470b11eeee82946fbf93d5944c63749bcdf65f6f',
  'php-http/guzzle7-adapter' => '1.0.0@fb075a71dbfa4847cf0c2938c4e5a9c478ef8b01',
  'php-http/httplug' => '2.4.0@625ad742c360c8ac580fcc647a1541d29e257f67',
  'php-http/promise' => '1.3.0@2916a606d3b390f4e9e8e2b8dd68581508be0f07',
  'phpoffice/phpspreadsheet' => '5.1.0@fd26e45a814e94ae2aad0df757d9d1739c4bf2e0',
  'phpstan/phpdoc-parser' => '2.3.0@1e0cd5370df5dd2e556a36b9c62f62e555870495',
  'predis/predis' => 'v3.0.1@34fb0a7da0330df1bab4280fcac4afdeeccc3edf',
  'psr/cache' => '3.0.0@aa5030cfa5405eccfdcb1083ce040c2cb8d253bf',
  'psr/clock' => '1.0.0@e41a24703d4560fd0acb709162f73b8adfc3aa0d',
  'psr/container' => '2.0.2@c71ecc56dfe541dbd90c5360474fbc405f8d5963',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-client' => '1.0.3@bb5906edc1c324c9a05aa0873d40117941e5fa90',
  'psr/http-factory' => '1.1.0@2b4765fddfe3b508ac62f829e852b1501d3f6e8a',
  'psr/http-message' => '1.1@cb6ce4845ce34a8ad9e68117c10ee90a29919eba',
  'psr/link' => '2.0.1@84b159194ecfd7eaa472280213976e96415433f7',
  'psr/log' => '3.0.2@f16e1d5863e37f8d8c2a01719f5b34baa2b714d3',
  'psr/simple-cache' => '2.0.0@8707bf3cea6f710bf6ef05491234e3ab06f6432a',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'ramsey/collection' => '1.3.0@ad7475d1c9e70b190ecffc58f2d989416af339b4',
  'ramsey/uuid' => '4.7.5@5f0df49ae5ad6efb7afa69e6bfab4e5b1e080d8e',
  'react/promise' => 'v3.2.0@8a164643313c71354582dc850b42b33fa12a4b63',
  'robrichards/xmlseclibs' => '3.1.4@bc87389224c6de95802b505e5265b0ec2c5bcdbd',
  'seld/jsonlint' => '1.10.2@9bb7db07b5d66d90f6ebf542f09fc67d800e5259',
  'seld/phar-utils' => '1.2.1@ea2f4014f163c1be4c601b9b7bd6af81ba8d701c',
  'seld/signal-handler' => '2.0.2@04a6112e883ad76c0ada8e4a9f7520bbfdb6bb98',
  'simshaun/recurr' => 'v5.0.3@7b136768d64f257065e38a804ee6d2f9af6ba6d1',
  'studio-42/elfinder' => '2.1.65@5535a8677558c44a20c19ff9b97ec37702f9c44d',
  'symfony/asset' => 'v7.4.0@0f7bccb9ffa1f373cbd659774d90629b2773464f',
  'symfony/cache' => 'v7.4.1@21e0755783bbbab58f2bb6a7a57896d21d27a366',
  'symfony/cache-contracts' => 'v3.6.0@5d68a57d66910405e5c0b63d6f0af941e66fc868',
  'symfony/clock' => 'v7.4.0@9169f24776edde469914c1e7a1442a50f7a4e110',
  'symfony/config' => 'v7.4.1@2c323304c354a43a48b61c5fa760fc4ed60ce495',
  'symfony/console' => 'v7.4.1@6d9f0fbf2ec2e9785880096e3abd0ca0c88b506e',
  'symfony/dependency-injection' => 'v7.4.2@baf614f7c15b30ba6762d4b1ddabdf83dbf0d29b',
  'symfony/deprecation-contracts' => 'v3.6.0@63afe740e99a13ba87ec199bb07bbdee937a5b62',
  'symfony/doctrine-bridge' => 'v7.4.1@7acd7ce1b71601b25d698bc2da6b52e43f3c72b3',
  'symfony/doctrine-messenger' => 'v7.4.1@f97f4ea899c467c2c8ff1b9c82b86baa9a7b2158',
  'symfony/dotenv' => 'v7.4.0@1658a4d34df028f3d93bcdd8e81f04423925a364',
  'symfony/error-handler' => 'v7.4.0@48be2b0653594eea32dcef130cca1c811dcf25c2',
  'symfony/event-dispatcher' => 'v7.4.0@9dddcddff1ef974ad87b3708e4b442dc38b2261d',
  'symfony/event-dispatcher-contracts' => 'v3.6.0@59eb412e93815df44f05f342958efa9f46b1e586',
  'symfony/expression-language' => 'v7.4.0@8b9bbbb8c71f79a09638f6ea77c531e511139efa',
  'symfony/filesystem' => 'v7.4.0@d551b38811096d0be9c4691d406991b47c0c630a',
  'symfony/finder' => 'v7.4.0@340b9ed7320570f319028a2cbec46d40535e94bd',
  'symfony/form' => 'v7.4.1@04984c79b08c70dc106498fc250917060d88aee2',
  'symfony/framework-bundle' => 'v7.4.1@2fa3b3ad6ed75ce0cc8cad8a5027b4f25b990bc3',
  'symfony/http-client' => 'v7.4.1@26cc224ea7103dda90e9694d9e139a389092d007',
  'symfony/http-client-contracts' => 'v3.6.0@75d7043853a42837e68111812f4d964b01e5101c',
  'symfony/http-foundation' => 'v7.4.1@bd1af1e425811d6f077db240c3a588bdb405cd27',
  'symfony/http-kernel' => 'v7.4.2@f6e6f0a5fa8763f75a504b930163785fb6dd055f',
  'symfony/intl' => 'v7.4.0@2fa074de6c7faa6b54f2891fc22708f42245ed5c',
  'symfony/lock' => 'v7.4.1@8ba5de8ab1b2d1766b654f60f1551bf4aefc542f',
  'symfony/mailer' => 'v7.4.0@a3d9eea8cfa467ece41f0f54ba28185d74bd53fd',
  'symfony/messenger' => 'v7.4.0@241f2f82048d2198f3ade29397c1ceddf30ccb24',
  'symfony/mime' => 'v7.4.0@bdb02729471be5d047a3ac4a69068748f1a6be7a',
  'symfony/monolog-bridge' => 'v7.4.0@189d16466ff83d9c51fad26382bf0beeb41bda21',
  'symfony/monolog-bundle' => 'v3.10.0@414f951743f4aa1fd0f5bf6a0e9c16af3fe7f181',
  'symfony/options-resolver' => 'v7.4.0@b38026df55197f9e39a44f3215788edf83187b80',
  'symfony/password-hasher' => 'v7.4.0@aa075ce6f54fe931f03c1e382597912f4fd94e1e',
  'symfony/polyfill-ctype' => 'v1.33.0@a3cc8b044a6ea513310cbd48ef7333b384945638',
  'symfony/polyfill-intl-grapheme' => 'v1.33.0@380872130d3a5dd3ace2f4010d95125fde5d5c70',
  'symfony/polyfill-intl-icu' => 'v1.33.0@bfc8fa13dbaf21d69114b0efcd72ab700fb04d0c',
  'symfony/polyfill-intl-idn' => 'v1.33.0@9614ac4d8061dc257ecc64cba1b140873dce8ad3',
  'symfony/polyfill-intl-normalizer' => 'v1.33.0@3833d7255cc303546435cb650316bff708a1c75c',
  'symfony/polyfill-mbstring' => 'v1.33.0@6d857f4d76bd4b343eac26d6b539585d2bc56493',
  'symfony/polyfill-php72' => 'v1.31.0@fa2ae56c44f03bed91a39bfc9822e31e7c5c38ce',
  'symfony/polyfill-php73' => 'v1.33.0@0f68c03565dcaaf25a890667542e8bd75fe7e5bb',
  'symfony/polyfill-php80' => 'v1.33.0@0cc9dd0f17f61d8131e7df6b84bd344899fe2608',
  'symfony/polyfill-php81' => 'v1.33.0@4a4cfc2d253c21a5ad0e53071df248ed48c6ce5c',
  'symfony/polyfill-php83' => 'v1.33.0@17f6f9a6b1735c0f163024d959f700cfbc5155e5',
  'symfony/polyfill-php84' => 'v1.33.0@d8ced4d875142b6a7426000426b8abc631d6b191',
  'symfony/polyfill-php85' => 'v1.33.0@d4e5fcd4ab3d998ab16c0db48e6cbb9a01993f91',
  'symfony/process' => 'v7.4.0@7ca8dc2d0dcf4882658313aba8be5d9fd01026c8',
  'symfony/property-access' => 'v7.4.0@537626149d2910ca43eb9ce465654366bf4442f4',
  'symfony/property-info' => 'v7.4.1@912aafe70bee5cfd09fec5916fe35b83f04ae6ae',
  'symfony/routing' => 'v7.4.0@4720254cb2644a0b876233d258a32bf017330db7',
  'symfony/security-bundle' => 'v7.4.0@48a64e746857464a5e8fd7bab84b31c9ba967eb9',
  'symfony/security-core' => 'v7.4.0@fe4d25e5700a2f3b605bf23f520be57504ae5c51',
  'symfony/security-csrf' => 'v7.4.0@ec41009e83589d0b3d86bd131d07e6fc8ecf35ab',
  'symfony/security-http' => 'v7.4.1@46a4432ad2fab65735216d113e18f1f9eb6d28ea',
  'symfony/serializer' => 'v7.4.2@1a957acb613b520e443c2c659a67c782b67794bc',
  'symfony/service-contracts' => 'v3.6.1@45112560a3ba2d715666a509a0bc9521d10b6c43',
  'symfony/stopwatch' => 'v7.4.0@8a24af0a2e8a872fb745047180649b8418303084',
  'symfony/string' => 'v7.4.0@d50e862cb0a0e0886f73ca1f31b865efbb795003',
  'symfony/translation' => 'v7.4.0@2d01ca0da3f092f91eeedb46f24aa30d2fca8f68',
  'symfony/translation-contracts' => 'v3.6.1@65a8bc82080447fae78373aa10f8d13b38338977',
  'symfony/twig-bridge' => 'v7.4.1@9103559ef3e9f06708d8bff6810f6335b8f1eee8',
  'symfony/twig-bundle' => 'v7.4.0@f83f530d00d1bbc6f7fafeb433077887c83326ef',
  'symfony/type-info' => 'v7.4.1@ac5ab66b21c758df71b7210cf1033d1ac807f202',
  'symfony/validator' => 'v7.4.2@569b71d1243ccc58e8f1d21e279669239e78f60d',
  'symfony/var-dumper' => 'v7.4.0@41fd6c4ae28c38b294b42af6db61446594a0dece',
  'symfony/var-exporter' => 'v7.4.0@03a60f169c79a28513a78c967316fbc8bf17816f',
  'symfony/web-link' => 'v7.4.0@c62edd6b52e31cf2f6f38fd3386725f364f19942',
  'symfony/yaml' => 'v7.4.1@24dd4de28d2e3988b311751ac49e684d783e2345',
  'twig/twig' => 'v3.22.1@1de2ec1fc43ab58a4b7e80b214b96bfc895750f3',
  'twilio/sdk' => '5.42.2@0cfcb871b18a9c427dd9e8f0ed7458d43009b48a',
  'voku/portable-ascii' => '2.0.1@b56450eed252f6801410d810c8e1727224ae0743',
  'voku/stop-words' => '2.0.1@8e63c0af20f800b1600783764e0ce19e53969f71',
  'wikimedia/less.php' => 'v5.4.0@75a0db4a7698b5fe668af553329605ac40f374af',
  'willdurand/jsonp-callback-validator' => 'v2.0.0@738c36e91d4d7e0ff0cac145f77057e0fb88526e',
  'willdurand/negotiation' => '3.1.0@68e9ea0553ef6e2ee8db5c1d98829f111e623ec2',
  'mautic/grapes-js-builder-bundle' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/plugin-clearbit' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/plugin-cloudstorage' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/plugin-crm' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/plugin-emailmarketing' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/plugin-focus' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/plugin-fullcontact' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/plugin-gmail' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/plugin-outlook' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/plugin-social' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/plugin-zapier' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/plugin-tagmanager' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-aurora' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-blank' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-brienz' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-cards' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-confirmme' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-fresh-center' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-fresh-fixed' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-fresh-left' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-fresh-wide' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-goldstar' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-neopolitan' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-oxygen' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-paprika' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-skyline' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-sparse' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-sunday' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-vibrant' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-1-2-1-2-column' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-1-2-1-column' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-1-2-column' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-1-3-1-3-column' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-1-3-column' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-attract' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-connect-through-content' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-creative' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-educate' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-gallery' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-make-announcement' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-showcase' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-simple-text' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-survey' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-trulypersonal' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-welcome' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-mono' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-blend' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-capture' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-chord' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-formscape' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-reachout' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/theme-multi-step' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
  'mautic/mautic' => '7.0.0@21ab270a3516635551d7464fc604f4e5e1ae3aea',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!class_exists(InstalledVersions::class, false) || !InstalledVersions::getRawData()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (class_exists(InstalledVersions::class, false) && InstalledVersions::getRawData()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }
}
